% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{evaluate.keras.engine.training.Model}
\alias{evaluate.keras.engine.training.Model}
\title{Evaluate a Keras model}
\usage{
\method{evaluate}{keras.engine.training.Model}(object, x = NULL, y = NULL,
  batch_size = NULL, verbose = 1, sample_weight = NULL, steps = NULL,
  ...)
}
\arguments{
\item{object}{Model object to evaluate}

\item{x}{Vector, matrix, or array of test data (or list if the model has
multiple inputs). If all inputs in the model are named, you can also pass a
list mapping input names to data. \code{x} can be \code{NULL} (default) if feeding
from framework-native tensors (e.g. TensorFlow data tensors).}

\item{y}{Vector, matrix, or array of target (label) data (or list if the model has
multiple outputs). If all outputs in the model are named, you can also pass
a list mapping output names to data. \code{y} can be \code{NULL} (default) if feeding
from framework-native tensors (e.g. TensorFlow data tensors).}

\item{batch_size}{Integer or \code{NULL}. Number of samples per gradient update.
If unspecified, \code{batch_size} will default to 32.}

\item{verbose}{Verbosity mode (0 = silent, 1 = progress bar, 2 = one line per
epoch).}

\item{sample_weight}{Optional array of the same length as x, containing
weights to apply to the model's loss for each sample. In the case of
temporal data, you can pass a 2D array with shape (samples,
sequence_length), to apply a different weight to every timestep of every
sample. In this case you should make sure to specify
\code{sample_weight_mode="temporal"} in \code{\link[=compile]{compile()}}.}

\item{steps}{Total number of steps (batches of samples) before declaring the
evaluation round finished. The default \code{NULL} is equal to the number of
samples in your dataset divided by the batch size.}

\item{...}{Unused}
}
\value{
Named list of model test loss (or losses for models with multiple
outputs) and model metrics.
}
\description{
Evaluate a Keras model
}
\seealso{
Other model functions: \code{\link{compile}},
  \code{\link{evaluate_generator}},
  \code{\link{fit_generator}}, \code{\link{fit}},
  \code{\link{get_config}}, \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{multi_gpu_model}},
  \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_generator}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
