% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kaya.R
\name{plot_kaya}
\alias{plot_kaya}
\title{Plot Kaya-identity variable}
\usage{
plot_kaya(
  kaya_data,
  variable,
  start_year = NA,
  stop_year = NA,
  y_lab = NULL,
  log_scale = FALSE,
  trend_line = FALSE,
  points = TRUE,
  font_size = 20
)
}
\arguments{
\item{kaya_data}{A tibble with Kaya-identity data}

\item{variable}{The name of the variable to plot (character)}

\item{start_year}{The year to start highlighting the data (should correspond
to the beginning of the trend calculation). Set to \code{NULL} to turn off
highlighting.}

\item{stop_year}{The year to stop highlighting the data (should correspond
to the beginning of the trend calculation). Set to \code{NULL} to turn off
highlighting.}

\item{y_lab}{Optional label for the y-axis}

\item{log_scale}{Use log scale for y axis}

\item{trend_line}{Include a trend line}

\item{points}{Plot points in addition to the line.}

\item{font_size}{Base size of the font for axis labels and titles.}
}
\value{
A plot object.
}
\description{
Plot Kaya-identity variable
}
\examples{
china <- get_kaya_data("China")
plot_kaya(china, "F", 2001, 2011)
uk <- get_kaya_data("United Kingdom")
plot_kaya(uk, "e", log_scale = TRUE, trend_line = TRUE)
world <- get_kaya_data("World")
plot_kaya(world, "g", 1982, log_scale = TRUE, trend_line = TRUE)
}
