% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vanbelle.R
\name{kappam_vanbelle}
\alias{kappam_vanbelle}
\title{Agreement between two groups of raters}
\usage{
kappam_vanbelle(
  ratingsGr1,
  ratingsGr2,
  ratingScale = NULL,
  weights = c("unweighted", "linear", "quadratic"),
  conf.level = 0.95
)
}
\arguments{
\item{ratingsGr1}{matrix of subjects x raters for 1st group of raters}

\item{ratingsGr2}{matrix of subjects x raters for 2nd group of raters}

\item{ratingScale}{character vector of the levels for the rating. Or \code{NULL}.}

\item{weights}{optional weighting schemes: \code{"unweighted"},
\code{"linear"},\code{"quadratic"}}

\item{conf.level}{confidence level for interval estimation}
}
\value{
list. kappa agreement between two groups of raters
}
\description{
This function expands upon Cohen's and Fleiss' Kappa as measures for
interrater agreement while taking into account the heterogeneity within each
group.
}
\details{
Data need to be stored with raters in columns.
}
\examples{
# compare rater1-rater2 vs rater3-rater6 from diagnoses-data
# (there is no systematic difference between both groups
#+as the raters are randomly selected per subject)
kappam_vanbelle(diagnoses[,1:2], diagnoses[,3:6])


}
\references{
Vanbelle, S., Albert, A. Agreement between Two Independent Groups
of Raters. Psychometrika 74, 477–491 (2009).
\doi{10.1007/s11336-009-9116-1}
}
