% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contracts.R
\name{contract_convert}
\alias{contract_convert}
\title{Convert contract names to factor intervals}
\usage{
contract_convert(x, decimal = FALSE)
}
\arguments{
\item{x}{A character vector of contract names.}

\item{decimal}{Should percentages be converted to decimals?}
}
\value{
A interval factor, unique factor, or logical vector.
}
\description{
Can perform one of three \strong{rough} conversions:
\enumerate{
\item For interval contracts (e.g., "220 - 229", "9\% or more", etc.), convert
the character strings to proper interval notation.
\item For contracts with multiple discrete outcomes (e.g., Candidate names),
convert the character vector to simple factors.
\item For markets with a single binary question (e.g., "Will the Democrats have
a brokered convention in 2020?"), contracts returned are always "Yes" which
is converted to \code{TRUE}.
}
}
