% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_decision.R
\name{log_decision}
\alias{log_decision}
\title{Document a decision}
\usage{
log_decision(
  label,
  description = "",
  alternatives = "",
  date = as.character(Sys.Date()),
  id = NULL,
  justification = "",
  silent = justifier::opts$get("silent"),
  ...
)
}
\arguments{
\item{label}{A human-readable label for the \code{decision},}

\item{description}{A human-readable description.}

\item{alternatives}{The alternatives between which was chosen.}

\item{date}{The date of the decision.}

\item{id}{Optionally, a manually specified id (otherwise, randomly
generated).}

\item{justification}{A justification specified using \code{\link[=jstf]{jstf()}}, or
more than one, combined with the \code{c} operator.}

\item{silent}{Whether to print messages.}

\item{...}{Any additional options will be stored in the decision.}
}
\value{
Invisibly, the decision as a \code{justifier} object (generated by
\code{\link[=dcsn]{dcsn()}}).
}
\description{
Used to programmatically document decisions - note that you have to
store them to a file to not lose them (i.e. if used interactively).
}
\examples{
clean_workspace(force = TRUE, silent=FALSE);
log_decision("First we start using `justifier`.",
             silent=FALSE);
log_decision(paste0("Then we start documenting our ",
                    "decisions and justifications."),
             silent=FALSE);
log_decision("Then we start learning from ourselves.",
             silent=FALSE);
workspace();
}
