% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_junctions_di.R
\name{number_of_junctions_di}
\alias{number_of_junctions_di}
\title{Calculate the expected number of junctions between two markers separated by
a given amount of recombination}
\usage{
number_of_junctions_di(N = Inf, H_0 = 0.5, t = 100, di = 1e-06)
}
\arguments{
\item{N}{Population Size}

\item{H_0}{Frequency of heterozygosity at t = 0}

\item{t}{Time since admixture}

\item{di}{Distance between two markers in Morgan}
}
\value{
Estimated number of junctions at time t
}
\description{
Calculate the expected number of junctions after t generations,
 provided information on the initial heterozygosity, population size, the
 number of generations since the onset of admixture and the distance between
 two markers.
}
\examples{
number_of_junctions_di(N = 100, H_0 = 0.5, t = 1000, di = 0.01)
}
