% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_time.R
\name{estimate_time}
\alias{estimate_time}
\title{Estimate the time since the onset of hybridization, using the number of
junctions}
\usage{
estimate_time(J = NA, N = Inf, R = Inf, H_0 = 0.5, C = 1)
}
\arguments{
\item{J}{The observed number of junctions}

\item{N}{Population Size}

\item{R}{Number of genetic markers}

\item{H_0}{Frequency of heterozygosity at t = 0}

\item{C}{Mean number of crossovers per meiosis (e.g. size in Morgan of the
chromosome)}
}
\value{
The number of generations passed since the onset of hybridization
}
\description{
Estimate the time since the onset of hybridization, following
equation 14 in Janzen et al. 2018
}
\examples{
cat("example calculate time")
J <- number_of_junctions(N = 100, R = 1000, H_0 = 0.5, C = 1, t = 200)
estimate_time(J = J, N = 100, R = 1000, H_0 = 0.5, C = 1)
# should be 200 again
}
