% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_unnest_longer.R
\name{json_unnest_longer}
\alias{json_unnest_longer}
\title{Unnest a JSON array column}
\usage{
json_unnest_longer(
  data,
  col,
  values_to = NULL,
  row_numbers_to = NULL,
  indices_to = NULL,
  ptype = NULL,
  wrap_scalars = FALSE,
  bigint_as_char = bigint_default()
)
}
\arguments{
\item{data}{A data frame.}

\item{col}{JSON-column of arrays to extract components from.}

\item{values_to}{Name of column to store vector values. Defaults to \code{col}.}

\item{row_numbers_to}{Name of column to store the row number before unnesting.}

\item{indices_to}{Name of column to store the array index of each element;
note that this starts with 0.}

\item{ptype}{Output type. If \code{NULL}, the default, the output type is
determined by computing the common type across all elements. Use
\code{new_json_array()} resp. \code{new_json_object()} if you know every element is
an array resp. object. Mind that the return type will only be \code{json2}.}

\item{wrap_scalars}{Should scalar values be wrapped?
Note that scalars are only wrapped if either
\itemize{
\item \code{ptype} is \code{new_json_array()} or \code{json2} vector.
\item \code{ptype} is \code{NULL} and the elements are a mix of scalar values and arrays.
}}

\item{bigint_as_char}{Convert big integers to character? The option
\code{jsontools.bigint_as_char} is used as default.}
}
\value{
A data frame, or subclass of data frame.
}
\description{
Unnest a column of JSON arrays in a data frame producing a longer data frame.
}
\examples{
df <- tibble::tibble(
  x = c("a", "b"),
  json = c("[1, 2]", "[3, 4, 5]")
)
df

df \%>\%
  json_unnest_longer(
    "json",
    row_numbers_to = "id",
    indices_to = "index"
  )
}
\seealso{
\code{\link[=json_unnest_wider]{json_unnest_wider()}}
}
