% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_json.R
\name{format_json}
\alias{format_json}
\alias{format_json_list}
\title{Convert \R{} objects to JSON}
\usage{
format_json(
  x,
  null = c("list", "null"),
  na = c("null", "string"),
  auto_unbox = FALSE,
  dataframe = c("rows", "columns", "values"),
  matrix = c("rowmajor", "columnmajor"),
  Date = c("ISO8601", "epoch"),
  POSIXt = c("string", "ISO8601", "epoch", "mongo"),
  factor = c("string", "integer"),
  complex = c("string", "list"),
  raw = c("base64", "hex", "mongo", "int", "js"),
  digits = 4,
  json_verbatim = TRUE,
  force = FALSE,
  pretty = FALSE,
  rownames = FALSE,
  always_decimal = FALSE,
  ...
)

format_json_list(
  x,
  null = c("list", "null"),
  na = c("null", "string"),
  auto_unbox = FALSE,
  dataframe = c("rows", "columns", "values"),
  matrix = c("rowmajor", "columnmajor"),
  Date = c("ISO8601", "epoch"),
  POSIXt = c("string", "ISO8601", "epoch", "mongo"),
  factor = c("string", "integer"),
  complex = c("string", "list"),
  raw = c("base64", "hex", "mongo", "int", "js"),
  digits = 4,
  json_verbatim = TRUE,
  force = FALSE,
  pretty = FALSE,
  rownames = FALSE,
  always_decimal = FALSE,
  ...
)
}
\arguments{
\item{x}{the object to be encoded}

\item{null, na, auto_unbox, dataframe, matrix, Date}{passed on to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON}}.}

\item{POSIXt, factor, complex, raw, digits, force, pretty, ...}{passed on to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON}}.}

\item{json_verbatim}{Leave JSON as it is and do not encode it again?}

\item{rownames}{For data.frames add a field \verb{_row} with the row name?}

\item{always_decimal}{Use real number notation in whole number doubles?}
}
\value{
A \code{json2} vector.
}
\description{
\code{format_json} is only a wrapper around the great \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}.
The differences are
\itemize{
\item expose argument \code{json_verbatim}, \code{rownames}, and \code{always_decimal}.
\item use \code{json_verbatim = TRUE} by default so that JSON isn't escaped again.
\item return a \code{json2} object.
}

\code{format_json_list()} converts each element of a list to JSON.

To make sure that a length one vector is not turned into an array use
\code{\link[=json_u]{json_u()}} or \code{\link[jsonlite:unbox]{jsonlite::unbox()}}.
}
\examples{
# null
x_null <- list(a = NULL, b = 1)
format_json(x_null)
format_json(x_null, null = "null")

# na
x_na <- list(a = NA, b = 1)
format_json(x_na)
format_json(x_na, na = "string")

# auto_unbox
x_autounbox <- list(1, 1:3)
format_json(x_autounbox)
format_json(x_autounbox, auto_unbox = TRUE)

# dataframe conversion
x_df <- iris[1:2, ]
format_json(x_df, pretty = TRUE)
format_json(x_df, dataframe = "columns", pretty = TRUE)
format_json(x_df, dataframe = "values", pretty = TRUE)

# json_verbatim
x_json <- json2('["a","b"]')
format_json(x_json)
format_json(x_json, json_verbatim = FALSE)

# Decimal vs significant digits
x <- 10 + pi
format_json(x)
format_json(x, digits = NA)
format_json(x, digits = 2)
format_json(x, digits = I(2))

# Force decimal representation
format_json(12)
format_json(12, always_decimal = TRUE)
}
\seealso{
\code{\link[=write_json]{write_json()}}, \code{\link[=format_json_rowwise]{format_json_rowwise()}}
}
