% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan.R
\name{kaplanUI}
\alias{kaplanUI}
\title{kaplanUI: shiny module UI for kaplan-meier plot}
\usage{
kaplanUI(id)
}
\arguments{
\item{id}{id}
}
\value{
Shiny module UI for kaplan-meier plot
}
\description{
Shiny module UI for kaplan-meier plot
}
\details{
Shiny module UI for kaplan-meier plot
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable);library(ggplot2)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     kaplanUI("kaplan")
   ),
   mainPanel(
     plotOutput("kaplan_plot"),
     ggplotdownUI("kaplan")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_kaplan <- callModule(kaplanModule, "kaplan", data = data, data_label = data.label,
                           data_varStruct = NULL)

  output$kaplan_plot <- renderPlot({
    print(out_kaplan())
  })
}
}
