% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/possible_ids.R
\name{store_checked_ids}
\alias{store_checked_ids}
\title{store checked variables as possible ids}
\usage{
store_checked_ids(checked_ids, possible_ids, env = .joynenv)
}
\arguments{
\item{checked_ids}{A vector of variable names that have been checked as possible IDs.}

\item{possible_ids}{A list containing potential identifiers. This list may contain \code{NULL} values, which will be removed by the function.}

\item{env}{An environment where the \code{checked_ids} will be stored. The default is \code{.joynenv}.}
}
\value{
A list of possible IDs with \code{NULL} values removed, and the \code{checked_ids} stored as an attribute.
}
\description{
This function processes a list of possible IDs by removing any \code{NULL} entries,
storing a set of checked variables as an attribute and in the specified environment,
and then returning the updated list of possible IDs.
}
\keyword{internal}
