% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{cisurvfitJMCS}
\alias{cisurvfitJMCS}
\title{Bootstrapped CI using \code{FastJM}}
\usage{
cisurvfitJMCS(object)
}
\arguments{
\item{object}{a \code{survfitJMCS} object}
}
\value{
Bootstrap CI for the survival probability and other relevant information for predicted survival plot
}
\description{
Bootstrapped CI for predicted survival probability
}
\examples{
  \donttest{
##
library(survival)
library(dplyr)
jmcs1<-jmcsBig(dtlong=data.frame(long2),
dtsurv = data.frame(surv2),
longm=y~ x7+visit,
survm=Surv(time,status)~x1+visit,
rd= ~ visit|id,
samplesize=200,id='id')
mod2<-jmcs1
P2<-survfitJMCS(model<-mod2,ids<-c(5),u<-seq(surv2[surv2$id==5,]$time,
surv2[surv2$id==5,]$time+10,0.2),obs.time='time')
bootci<-cisurvfitJMCS(P2)
print(bootci)
##
  }
}
