% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_timewise_statistics.R
\name{compute_timewise_statistics}
\alias{compute_timewise_statistics}
\title{Fit Julia regression models to each time point of a time series data}
\usage{
compute_timewise_statistics(
  jlmer_spec,
  family = c("gaussian", "binomial"),
  statistic = c("t", "chisq"),
  ...
)
}
\arguments{
\item{jlmer_spec}{Data prepped for jlmer from \code{make_jlmer_spec()}}

\item{family}{A GLM family. Currently supports "gaussian" and "binomial".}

\item{statistic}{Test statistic for calculating cluster mass.
Can be one of \code{"t"} (default) from the regression model output or
\code{"chisq"} from a likelihood ratio test (takes about twice as long to calculate).}

\item{...}{Optional arguments passed to Julia for model fitting.
Defaults to \code{fast = TRUE} (when \code{family = "binomial"}) and \code{progress = FALSE}.}
}
\value{
A predictor-by-time matrix of cluster statistics, of class \code{timewise_statistics}.
}
\description{
Fit Julia regression models to each time point of a time series data
}
\examples{
\dontshow{if (julia_setup_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(cache_dir = tempdir(), verbose = FALSE)
julia_progress(show = FALSE)
}

library(dplyr, warn.conflicts = FALSE)

# Specification object
spec <- make_jlmer_spec(
  weight ~ 1 + Diet, filter(ChickWeight, Time <= 20),
  subject = "Chick", time = "Time"
)
spec

# Predictor x Time matrix of t-statistics from regression output
empirical_statistics <- compute_timewise_statistics(spec)
round(empirical_statistics, 2)

# Collect as dataframe with `tidy()`
empirical_statistics_df <- tidy(empirical_statistics)
empirical_statistics_df

# Timewise statistics are from regression models fitted to each time point
# - Note the identical statistics at `Time == 0`
empirical_statistics_df \%>\%
  filter(time == 0)
to_jlmer(weight ~ 1 + Diet, filter(ChickWeight, Time == 0)) \%>\%
  tidy() \%>\%
  select(term, statistic)

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=jlmer]{jlmer()}}, \code{\link[=make_jlmer_spec]{make_jlmer_spec()}}
}
