% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse}
\alias{parse}
\alias{parse_template}
\alias{parse_template.character}
\alias{parse_template.fs_path}
\title{Parse template}
\usage{
parse_template(.x, .config)

\method{parse_template}{character}(.x, .config = default_config())

\method{parse_template}{fs_path}(.x, .config = default_config())
}
\arguments{
\item{.x}{The template. Choices:
\itemize{
\item A template string.
\item A path to a template file (use \code{\link[fs:path]{fs::path()}}).
}}

\item{.config}{The engine configuration. The default matches Jinja defaults,
but you can use \code{\link[=jinjar_config]{jinjar_config()}} to customize things like syntax delimiters,
whitespace control, and loading auxiliary templates.}
}
\value{
A \code{"jinjar_template"} object.
}
\description{
Sometimes you want to render multiple copies of a template, using different
sets of data variables. \code{\link[=parse_template]{parse_template()}} returns an intermediate version
of the template, so you can \code{\link[=render]{render()}} repeatedly without re-parsing the
template syntax.
}
\examples{
x <- parse_template("Hello {{ name }}!")
render(x, name = "world")
}
\seealso{
\itemize{
\item \code{\link[=render]{render()}} to render the final document using data variables.
\item \code{vignette("template-syntax")} describes how to write templates.
}
}
