% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{rmNA}
\alias{rmNA}
\title{remove NA values}
\usage{
rmNA(
  x,
  naValue = NULL,
  rmNULL = FALSE,
  nullValue = naValue,
  rmInfinite = TRUE,
  infiniteValue = NULL,
  rmNAnames = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{vector input}

\item{naValue}{NULL or single replacement value for NA entries. If NULL,
then NA entries are removed from the result.}

\item{rmNULL}{\code{logical} whether to replace NULL entries with \code{nullValue}}

\item{nullValue}{NULL or single replacement value for NULL entries. If NULL,
then NULL entries are removed from the result.}

\item{rmInfinite}{\code{logical} whether to replace Infinite values with
infiniteValue}

\item{infiniteValue}{value to use when rmInfinite==TRUE to replace
entries which are Inf or -Inf.}

\item{rmNAnames}{\code{logical} whether to remove entries which have NA as the
name, regardless whether the entry itself is NA.}

\item{verbose}{\code{logical} whether to print verbose output}

\item{...}{additional arguments are ignored.}
}
\value{
vector with NA entries either removed, or replaced with naValue,
and NULL entries either removed or replaced by nullValue.
}
\description{
remove NA values
}
\details{
This function removes NA values, by default shortening a vector as a result,
but optionally replacing NA and Infinite values with fixed values.
}
\examples{
# by default it removes NA, shortening the vector
rmNA(c(1, 5, 4, NA, 10, NA))

# convenient to replace NA with a fixed value
rmNA(c(1, 5, 4, NA, 10, NA), naValue=0)

m <- matrix(ncol=3, 1:9)
m[1, 2] <- NA;
rmNA(m, naValue=-1)

# by default NA and Inf is removed
rmNA(c(1, 5, 4, NA, 10, NA, Inf, -Inf))

# NA and Inf can be replaced, note Inf retains the sign
rmNA(c(1, 5, 4, NA, 10, NA, Inf, -Inf), naValue=0, infiniteValue=100)

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
