% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{igrep}
\alias{igrep}
\title{case-insensitive grep}
\usage{
igrep(..., ignore.case = TRUE)
}
\arguments{
\item{..., ignore.case}{parameters sent to \code{base::grep()}}
}
\value{
vector of matching indices
}
\description{
case-insensitive grep
}
\details{
This function is a simple wrapper around \code{base::grep()} which
runs in case-insensitive mode. It is mainly used to save keystrokes,
but is consistently named alongside \code{\link{vgrep}} and
\code{\link{vigrep}}.
}
\examples{
V <- paste0(LETTERS[1:5], LETTERS[4:8]);
igrep("D", V);
igrep("d", V);
vigrep("d", V);

}
\seealso{
Other jam grep functions: 
\code{\link{grepls}()},
\code{\link{igrepHas}()},
\code{\link{igrepl}()},
\code{\link{provigrep}()},
\code{\link{unigrep}()},
\code{\link{unvigrep}()},
\code{\link{vgrep}()},
\code{\link{vigrep}()}
}
\concept{jam grep functions}
