% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{exp2signed}
\alias{exp2signed}
\title{exponentiate log2 values with directionality}
\usage{
exp2signed(x, offset = 1, base = 2, ...)
}
\arguments{
\item{x}{\code{numeric} vector}

\item{offset}{\code{numeric} subtracted from exponentiated values
prior to multiplying by the \code{sign(x)}.}

\item{base}{\code{numeric} value indicating the logarithmic base used.
For example \code{base=2} indicates values were transformed using
\code{log2()}.}

\item{...}{additional arguments are ignored.}
}
\value{
numeric vector of exponentiated values.
}
\description{
exponentiate log2 values with directionality
}
\details{
This function is the reciprocal to \code{log2signed()}.

It #' exponentiates the absolute values of \code{x},
then subtracts the \code{offset}, then multiplies results
by the \code{sign(x)}.

The \code{offset} is typically used to maintain
directionality of values during log transformation by
requiring all absolute values to be \code{1} or larger, thus
by default \code{offset=1}.
}
\examples{
x <- c(-100:100)/10;
z <- log2signed(x);
#plot(x=x, y=z, xlab="x", ylab="log2signed(x)")
plot(x=x, y=exp2signed(z), xlab="x", ylab="exp2signed(log2signed(x))")
plot(x=z, y=exp2signed(z), xlab="log2signed(x)", ylab="exp2signed(log2signed(x))")

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
