context("Rcpp generate JSFS statistic")

test_that("test.addSegSitesToJsfs", {
    seg.sites <- matrix(c(1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1), 
        4, 3)
    jsfs <- matrix(0, 3, 3)
    jsfs.new <- addSegSitesToJsfs(seg.sites, c(2, 2), jsfs)
    expect_true(is.matrix(jsfs.new))
    expect_equal(dim(jsfs.new), c(3, 3))
    expect_equal(sum(jsfs), 0)
    expect_equal(sum(jsfs.new), 3)
    expect_equal(jsfs.new[2, 1], 1)
    expect_equal(jsfs.new[3, 2], 1)
    expect_equal(jsfs.new[2, 2], 1)
    seg.sites <- matrix(c(1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0), 
        4, 3)
    jsfs <- matrix(0, 3, 3)
    jsfs.new <- addSegSitesToJsfs(seg.sites, c(2, 2), jsfs)
    expect_true(is.matrix(jsfs.new))
    expect_equal(dim(jsfs.new), c(3, 3))
    expect_equal(sum(jsfs), 0)
    expect_equal(sum(jsfs.new), 3)
    expect_equal(jsfs.new[3, 3], 1)
    expect_equal(jsfs.new[1, 3], 1)
    expect_equal(jsfs.new[3, 1], 1)
    seg.sites <- matrix(c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), 
        4, 3)
    jsfs <- matrix(0, 3, 3)
    jsfs.new <- addSegSitesToJsfs(seg.sites, c(2, 2), jsfs)
    expect_true(is.matrix(jsfs.new))
    expect_equal(dim(jsfs.new), c(3, 3))
    expect_equal(sum(jsfs), 0)
    expect_equal(sum(jsfs.new), 3)
    expect_equal(jsfs.new[3, 3], 3)
    seg.sites <- matrix(c(1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
        1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0), 
        5, 6)
    jsfs <- matrix(0, 4, 3)
    jsfs.new <- addSegSitesToJsfs(seg.sites, c(3, 2), jsfs)
    expect_true(is.matrix(jsfs.new))
    expect_equal(dim(jsfs.new), c(4, 3))
    expect_equal(sum(jsfs), 0)
    expect_equal(sum(jsfs.new), 6)
    expect_equal(jsfs.new[4, 3], 1)
    expect_equal(jsfs.new[4, 2], 2)
    expect_equal(jsfs.new[1, 3], 1)
    expect_equal(jsfs.new[3, 3], 1)
    expect_equal(jsfs.new[2, 1], 1)
})

