% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{boundPValue}
\alias{boundPValue}
\title{Construct p-values for treatment effects under partial
identification}
\usage{
boundPValue(ci, bound, bound.resamples, n, m, levels, type, tol = 1e-08)
}
\arguments{
\item{ci}{matrix or list. If \code{type} is set to 'forward' or
'backward', then \code{ci} should be a matrix of forward or
backward confidence intervals corresponding to the levels
declared in the option \code{levels}. If \code{type} is set to
'both', then \code{ci} should be a list of two elements. One
element is a matrix of forward confidence intervals, and the
other element is a matrix of backward confidence intervals.}

\item{bound}{vector, bound of the treatment effects under partial
identification.}

\item{bound.resamples}{matrix, stacked bounds of the treatment
effects under partial identification. Each row corresponds to a
subset resampled from the original data set.}

\item{n}{integer, size of original data set.}

\item{m}{integer, size of resampled data sets.}

\item{levels}{vector, real numbers between 0 and 1. Values
correspond to the level of the confidence intervals constructed
via bootstrap.}

\item{type}{character. Set to 'forward' to construct the forward
confidence interval for the treatment effect bound. Set to
'backward' to construct the backward confidence interval for
the treatment effect bound. Set to 'both' to construct both
types of confidence intervals.}

\item{tol}{numeric, default set to 1e-08. The p-value is
constructed by iteratively adjusting the confidence level to
find a confidence interval that does not contain 0. When the
adjustment of the confidence level falls below \code{tol}, no
further iterations are performed.}
}
\value{
If \code{type} is 'forward' or 'backward', a scalar p-value
    corresponding to the type of confidence interval is
    returned. If \code{type} is 'both', a vector of p-values
    corresponding to the forward and backward confidence intervals
    is returned.
}
\description{
This function estimates the p-value for the treatment effect under
partial identification. p-values corresponding to forward and
backward confidence intervals can be returned.
}
