% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{get_fitted}
\alias{get_fitted}
\title{Get model all fitted values.}
\usage{
get_fitted(model, se = 1.96, rm.ranef = NULL, as.data.frame = FALSE,
  print.summary = getOption("itsadug_print"))
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}.}

\item{se}{A number to scale the standard error. Defaults to 1.96, resulting 
in 95\% confidence intervals. For 99\% confidence intervals use a value of 
2.58.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is FALSE. Alternatively a string (or vector of strings) with the 
name of the random effect(s) to remove.}

\item{as.data.frame}{Logical: return values as data frame or as vector. 
Default is FALSE (returning a vector).}

\item{print.summary}{Logical: whether or not to print a summary of the 
values selected for each predictor. 
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}
}
\value{
A data frame with estimates and optionally errors.
}
\description{
Get model all fitted values.
}
\examples{
data(simdat)
\dontrun{
m1 <- bam(Y ~ Group + s(Time, by=Group)+ s(Subject, bs='re'), data=simdat)

# as.data.frame FALSE and rm.ranef=NULL results in fitted():
all( get_fitted(m1) == fitted(m1) )

# now fitted values without random effects:
all( get_fitted(m1, rm.ranef=TRUE) == fitted(m1) )
head(get_fitted(m1, rm.ranef=TRUE))

# without summary:
infoMessages("off")
head(get_fitted(m1, rm.ranef=TRUE))
infoMessages("on")
}
}
\author{
Jacolien van Rij
}
\seealso{
Other Model predictions: \code{\link{get_coefs}},
  \code{\link{get_difference}},
  \code{\link{get_modelterm}},
  \code{\link{get_predictions}}, \code{\link{get_random}}
}

