% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot_smooth.R
\name{plot_smooth}
\alias{plot_smooth}
\title{Visualization of smooths.}
\usage{
plot_smooth(x, view = NULL, cond = list(), rm.ranef = NULL, n.grid = 30,
  rug = TRUE, col = "black", add = FALSE, se = 1.96, shade = TRUE,
  eegAxis = FALSE, print.summary = TRUE, main = NULL, xlab = NULL,
  ylab = NULL, ylim = NULL, h0 = 0, v0 = NULL, ...)
}
\arguments{
\item{x}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{view}{Text string containing the name of the smooth
to be displayed. Note that
variables coerced to factors in the model formula won't work as view
variables.}

\item{cond}{A named list of the values to use for the other predictor terms
(not in view). Used for choosing between smooths that share the same view
predictors.}

\item{rm.ranef}{Logical: whether or not to remove random effects.
Default is TRUE.}

\item{n.grid}{The number of grid nodes in each direction used for
calculating the plotted surface.}

\item{rug}{Logical: when TRUE (default) then the covariate to which the
plot applies is displayed as a rug plot at the foot of each plot of a 1-d
smooth. Setting to FALSE will speed up plotting for large datasets.}

\item{col}{The colors for the lines and the error bars of the plot.}

\item{add}{Logical: whether or not to add the lines to an existing plot, or
start a new plot (default).}

\item{se}{If less than or equal to zero then only the predicted surface is
plotted, but if greater than zero, then the predicted values plus
confidence intervals are plotted. The value of se will be multiplied with
the standard error (i.e., 1.96 results in 95\%CI and 2.58).}

\item{shade}{Logical: Set to TRUE to produce shaded regions as confidence #' bands for smooths (not avaliable for parametric terms, which are plotted
using termplot).}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting the
negative amplitudes upwards as traditionally is done in EEG research.
If eeg.axes is TRUE, labels for x- and y-axis are provided, when not
provided by the user. Default value is FALSE.}

\item{print.summary}{Logical: whether or not to print summary.}

\item{main}{Changing the main title for the plot, see also title.}

\item{xlab}{Changing the label for the x axis,
defaults to a description of x.}

\item{ylab}{Changing the label for the y axis,
defaults to a description of y.}

\item{ylim}{the y limits of the plot.}

\item{h0}{A vector indicating where to add solid horizontal lines for
reference. By default no values provided.}

\item{v0}{A vector indicating where to add dotted vertical lines for
reference. By default no values provided.}

\item{...}{other options to pass on to lines and plot,
see \code{\link[graphics]{par}}}
}
\description{
Plots a smooth from a \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}} model based on predictions.
In contrast with the default \code{\link[mgcv]{plot.gam}}, this function
plots the summed effects and optionally removes the random effects.
}
\examples{
data(simdat)

\dontrun{
# Model with random effect and interactions:
m1 <- bam(Y ~ te(Time, Trial)+s(Time, Subject, bs='fs', m=1),
    data=simdat)

# Default plot produces only surface of Time x Trial:
plot(m1, select=1)
# Only the Time component:
plot_smooth(m1, view="Time")
# Note the summary that is printed.

# without random effects:
plot_smooth(m1, view="Time", rm.ranef=TRUE)

# Plot summed effects:
dev.new(width=8, height=4) # use x11(,8,4) on Linux
par(mfrow=c(1,2))
fvisgam(m1, view=c("Time", "Trial"),
    plot.type='contour', color='topo', main='interaction',
    rm.ranef=TRUE)
arrows(x0=0, x1=2200, y0=-5, y1=-5, col='red',
    code=2, length=.1, lwd=2, xpd=TRUE)
plot_smooth(m1, view='Time', cond=list(Trial=-5),
    main='Trial=-5', rm.ranef=TRUE)
}
# see the vignette for examples:
vignette("plotfunctions", package="itsadug")
}
\author{
Jacolien van Rij and Martijn Wieling.
}
\seealso{
\code{\link[mgcv]{plot.gam}}, \code{\link{plot_diff}}

Other functions for interpreting nonlinear effects: \code{\link{fvisgam}},
  \code{\link{vis.gam2}}; \code{\link{plotDiff2D}},
  \code{\link{plot_diff2}}; \code{\link{plotDiff}},
  \code{\link{plot_diff}}; \code{\link{plot_parametric}};
  \code{\link{pvis.gam}}, \code{\link{pvisgam}}
}

