% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predictions.R
\name{get_modelterm}
\alias{get_modelterm}
\title{Get estimated for selected model terms.}
\usage{
get_modelterm(model, select, cond = NULL, n.grid = 30, se = TRUE,
  f = 1.96)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{select}{A number, indicating the model term to be selected.}

\item{cond}{A named list of the values to restrict the estimates for the
random predictor terms. When NULL (default) all levels are returned.
Only relevant for complex interactions, which involve more than two
dimensions.}

\item{n.grid}{Number of data points estimated for each random smooth.}

\item{se}{Logical: whether or not to return the confidence interval or
standard error around the estimates.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting
in 95\% confidence intervals. For 99\% confidence intervals use a value of
2.58.}
}
\value{
A data frame with estimates for the selected smooth term.
}
\description{
Get estimated for selected model terms.
}
\examples{
# see the vignette for examples:
vignette("plotfunctions", package="itsadug")
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for model predictions: \code{\link{get_difference}};
  \code{\link{get_predictions}}; \code{\link{get_random}}
}

