% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes.R
\docType{class}
\name{Specimen}
\alias{Specimen}
\alias{.R_Specimen_ctor}
\title{Class providing object with methods to mimic in silico Specimens}
\value{
Objects of R6 class with methods to mimic in silico Specimens.
}
\description{
Mean to mimic a in silico Specimens. It is the working instances of
    the simulator.
}
\details{
Object of R6 class that points to C++ objetcs.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.ptr}}{External pointer to the instance of the C++ class Specie.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{.R_Specimen_ctor$new()}}
\item \href{#method-print}{\code{.R_Specimen_ctor$print()}}
\item \href{#method-alpha}{\code{.R_Specimen_ctor$alpha()}}
\item \href{#method-genotype}{\code{.R_Specimen_ctor$genotype()}}
\item \href{#method-cross}{\code{.R_Specimen_ctor$cross()}}
\item \href{#method-selfcross}{\code{.R_Specimen_ctor$selfcross()}}
\item \href{#method-dh}{\code{.R_Specimen_ctor$dh()}}
\item \href{#method-mirror}{\code{.R_Specimen_ctor$mirror()}}
\item \href{#method-look}{\code{.R_Specimen_ctor$look()}}
\item \href{#method-clone}{\code{.R_Specimen_ctor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of a Specimen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$new(ptr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ptr}}{an Smart pointer to an instance of a Specimen C++ class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Specimen` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print/Show an instance of the Specimen class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments to be passed to print.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-alpha"></a>}}
\if{latex}{\out{\hypertarget{method-alpha}{}}}
\subsection{Method \code{alpha()}}{
Evaluates the breeding value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$alpha(trait)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trait}}{an instance of the class Trait.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the breeding value of the specimen for the given trait.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-genotype"></a>}}
\if{latex}{\out{\hypertarget{method-genotype}{}}}
\subsection{Method \code{genotype()}}{
Codify Specimen's Genotypes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$genotype(phase = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{phase}}{logical should the codes keep the phase.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric or character vector with the codified Specimen's genotypes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cross"></a>}}
\if{latex}{\out{\hypertarget{method-cross}{}}}
\subsection{Method \code{cross()}}{
Performs the simple bi-parental cross.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$cross(n = 1, gid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{a length-one integer vector with the size of the progeny.}

\item{\code{gid}}{instance of the class specimen which will be used to mate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a size \emph{n} list with instances of the class Specimen that 
    represent new individuals belonging to the progeny of the respective mating 
    scheme.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-selfcross"></a>}}
\if{latex}{\out{\hypertarget{method-selfcross}{}}}
\subsection{Method \code{selfcross()}}{
Performs the selfcross.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$selfcross(n = 1, replace = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{a length-one integer vector with the size of the progeny.}

\item{\code{replace}}{logical scalar indicating if the outcome of the function will
replace the current instance of the Specimen}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a size \emph{n} list with instances of the class Specimen that 
    represent new individuals belonging to the progeny of the respective mating 
    scheme.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-dh"></a>}}
\if{latex}{\out{\hypertarget{method-dh}{}}}
\subsection{Method \code{dh()}}{
Performs the double-haploid duplication
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$dh(n = 1, replace = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{a length-one integer vector with the size of the progeny.}

\item{\code{replace}}{logical scalar indicating if the outcome of the function will 
replace the current instance of the Specimen}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a size \emph{n} list with instances of the class Specimen that 
    represent new individuals belonging to the progeny of the respective mating 
    scheme.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mirror"></a>}}
\if{latex}{\out{\hypertarget{method-mirror}{}}}
\subsection{Method \code{mirror()}}{
Generates a `mirrored` specimen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$mirror()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an instance of the Specimen class with all loci mirrored.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-look"></a>}}
\if{latex}{\out{\hypertarget{method-look}{}}}
\subsection{Method \code{look()}}{
Acess specific locus' value from specimen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$look(snp, phase = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{snp}}{an character string with the name of the locus to lookup.}

\item{\code{phase}}{logical should the codes keep the phase.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the genotype of the given locus.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specimen_ctor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
