% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clumped.R
\name{temp_D47}
\alias{temp_D47}
\title{Clumped isotope thermometry}
\usage{
temp_D47(D47_CDES90, D47_error, eq)
}
\arguments{
\item{D47_CDES90}{Carbonate D47 values expressed on the CDES90 scale (‰).}

\item{D47_error}{Error on the D47 value. Optional.}

\item{eq}{Equation used for the calculation. Options are as in \code{\link[=D47]{D47()}}.}
}
\value{
Returns the carbonate growth temperature (°C). If \code{D47_error}
is specified \code{temp_D47()} returns a data frame.
}
\description{
\code{temp_D47()} calculates carbonate growth temperature from D47 value.
}
\details{
The D47 vs temperature equations are listed at \code{\link[=D47]{D47()}}.
}
\examples{
temp_D47(D47_CDES90 = 0.577, eq = "Petersen19")

}
\references{
References are listed at \code{\link[=D47]{D47()}}.
}
\seealso{
\code{\link[=D47]{D47()}} calculates the equilibrium carbonate D47 value.

Other thermometry: 
\code{\link{temp_D48}()},
\code{\link{temp_d18O}()}
}
\concept{thermometry}
