\name{CTi}
\alias{CTi}

\title{Conditional Test for contrasting isotropic order}

\description{
This function calculates the p-value corresponding to the conditional test where the hypotheses are whether the data follow a fixed (general) isotropic order or not.
}

\usage{CTi(data, levels=c(1:nrow(data)), kappa=NULL)}

\arguments{
  \item{data}{matrix with the data. See details.}
  \item{levels}{a numeric vector with the order to be contrasted.}
  \item{kappa}{numeric, only to be set if there are no replications in the data set.}

}

\details{
This function performs the conditional test to constrast the hypotheses:

\eqn{\hspace{1.7cm}H_{0}:}{Ho:} The circular parameters follow a fixed (general) isotropic order.

\eqn{\hspace{1.7cm}H_{1}: \hspace{0.1cm}H_{0}}{H1: Ho:} is not true.

This conditional test is a modification of the likelihood ratio test. See Fernandez et al. (2011) for full details.  There are two cases depending on whether \eqn{\kappa}{kappa} is known or not. If \eqn{\kappa}{kappa} is known, the test statistic is:

\deqn{T=2\kappa SCE(\theta,\widetilde{\theta})}{T=2*k*SCE(theta, CIRE)}
and the asymptotic distribution is \eqn{\chi ^{2}_{q-m}}{chisquare with \code{q-m} degrees of freedom}, where \emph{q} is the total number of parameters and \emph{m} is the number of level sets for the Circular Isotonic Regression Estimator under the isotropic order, \eqn{\widetilde{\theta}}{CIRE} (i.e. \emph{m} is the number of different numerical values in \eqn{\widetilde{\theta}}{CIRE}) and the SCE is the Sum of Circular Error defined in \code{\link{cirSCE}}.

\eqn{\hspace{1.7cm}CT: \hspace{0.2cm} H_{0}}{CT: Ho} is rejected whenever \eqn{T \geq c(m)}{T >=c(m)},  

where \emph{c(m)} is chosen so that \eqn{pr(\chi ^{2}_{q-m} \geq c(m))=\frac{\alpha}{1-pr(C_{GIO})}}{pr(chi ^2_{q-m} >= c(m))= alpha / (1-pr(C_GIO))}, where \eqn{pr(C_{GIO})=\frac{l_1!l_2!...l_L!}{(q-1)!}}{pr(C_GIO)=(l_1!l_2!...l_L!)/(q-1)!} is the probability of the order cone \eqn{C_{GIO}}{C_GIO} generated by the null hypothesis under the equality of the parameters, see \code{\link{CIREi}} for the full definition of \eqn{C_{GIO}}{C_GIO}.  If \emph{t*} is the value of \emph{T} for the data, the p-value of the test is:  \eqn{p-value = pr(\chi ^{2}_{q-m} \geq t^{*})[1-pr(C_{GIO})]}{p-value = pr(chi_{q-m}^{2} >= t*)[1-pr(C_GIO)]}.

When \eqn{\kappa}{kappa} is unknown, data should have replications in order to estimate \eqn{\kappa}{kappa}.  In this case, the test statistic is:

\deqn{T=\frac{2\widehat{\kappa} SCE(\theta,\widetilde{\theta})}{q}}{T=2*k_estimate*SCE(theta, CIRE)/q}
and the asymptotic distribution is \eqn{F_{q-m,q-1}}{F with \code{q-m} and \code{q-1} degrees of freedom}. The p-value of the test is:  \eqn{p-value = pr(F_{q-m,q-1} \geq t^{*})[1-pr(C_{GIO})]}{p-value = pr(F_{q-m,q-1} >= t*)[1-pr(C_GIO)]}.

Further information in \enc{Fernandez}{Fernandez} et al. (2011).  The result of \emph{CTi} is the p-value of this test.

Each column of the matrix \code{data} is a replication whereas each row is a population.  All the values must belong to the interval \eqn{[0,2\pi]}{[0,2pi]}. 

The order to be contrasted is introduced in \code{levels} in the form of a numeric vector with length equal to the number of populations. Each value of the argument establishes the level of the order the corresponding population is assigned to.  The default value is the sequence corresponding to the simple order (1, 2, ..., q).  Notice that no particular order is assumed among the populations belonging to the same level set.

In case of no replications, \code{data} has only one column with the angular means. In this case the value of \eqn{\kappa}{kappa} has to be introduced in the argument \code{kappa}.  When there are replications, the estimation of \code{kappa} is done internally using the \code{\link{cirkappa}} function developed in this package.  
}

\value{
\item{pvalue}{numeric, it is the p-value what results of the conditional test.}
}


\author{Author(s): The implementation in R is done by Sandra \enc{Barragan}{Barragan} based on the SAS code written by Miguel A. Fernandez.
Maintainer:<sandraba@eio.uva.es>}


\references{

Mardia, K. and Jupp, P. (2000).
   \emph{Directional Statistics}, Chichester: Wiley.

Rueda, C., \enc{Fernandez}{Fernandez}, M. A. and Peddada, S. D. (2009).
  Estimation of parameters subject to order restrictions on a circle with application to estimation of phase angles of cell-cycle genes.
  \emph{Journal of the American Statistical Association}, \bold{104}, n485; pp 338--347.
  \url{http://pubs.amstat.org/doi/abs/10.1198/jasa.2009.0120}

\enc{Fernandez}{Fernandez}, M. A., Rueda, C. and Peddada, S. D. (2011).
   Isotropic order among core set of orthologs conserved between budding and fission yeasts. \emph{Prepint}.
}

\seealso{
\code{\link{CIREi}}, \code{\link{cirmean}}, \code{\link{cirSCE}}, \code{\link{cirkappa}}, \code{\link{mrl}}.
}


\examples{
data(cirdata)
# Example without replications and a general isotropic order:
data<-cbind(cirdata)
CTi(data,levels=c(1,2,1,3,3,4,5,6), kappa=0.2)
# Example with replications and the isotropic order (by default):
data(datareplic)
CTi(data=datareplic)
}

\keyword{circular}
\keyword{isotonic}
\keyword{CIRE}
\keyword{test}