% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-placer.R
\name{label_placer_simple}
\alias{label_placer_simple}
\title{Generic label placement function}
\usage{
label_placer_simple(lines, labels_data, placer_fun)
}
\arguments{
\item{lines}{Isolines object for which labels should be placed.}

\item{labels_data}{A data frame containing information about which labels should
be placed.}

\item{placer_fun}{A function that takes an individual isoline plus its associated
break id as input and returns a data frame specifying label positions. The data
frame should have three columns called \code{x}, \code{y}, and \code{theta}. \code{x} and \code{y} specify
the label position, and \code{theta} specifies the label angle in radians. The data
frame can have multiple rows, which results in the same label being placed in
multiple locations.}
}
\description{
The simple label placer processes separate isolines independently and places
labels for each line using a placer function that does the actual placement work.
This label placer is not meant to be used by end users, but rather facilitates the
development of new label placers, such as \code{\link[=label_placer_minmax]{label_placer_minmax()}}.
}
\keyword{internal}
