% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itempool-class-methods.R
\name{add_misc}
\alias{add_misc}
\alias{add_misc,Item-method}
\alias{add_misc,Testlet-method}
\alias{add_misc,Itempool-method}
\title{Add or change a named value to 'misc' slot of an \code{\link{Item-class}},
\code{\link{Itempool-class}} or \code{\link{Testlet-class}} object.}
\usage{
add_misc(ip, value)

\S4method{add_misc}{Item}(ip, value)

\S4method{add_misc}{Testlet}(ip, value)

\S4method{add_misc}{Itempool}(ip, value)
}
\arguments{
\item{ip}{An \code{\link{Item-class}}, \code{\link{Testlet-class}} or
\code{\link{Itempool-class}} object.}

\item{value}{A list where each element should be named. Elements within the
list will be added to 'misc' slot.}
}
\value{
An object with added 'misc' slot.
}
\description{
Add or change a named value to 'misc' slot of an \code{\link{Item-class}},
\code{\link{Itempool-class}} or \code{\link{Testlet-class}} object.
}
\examples{
item <- item(b = 1)
add_misc(item, list(sympson_hetter_k = .75))

}
\author{
Emre Gonulates
}
