% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Itempool-class-methods.R
\name{c,Item-method}
\alias{c,Item-method}
\alias{c,Itempool-method}
\alias{c,Testlet-method}
\title{Concatenate \code{Item}, \code{Itempool} or \code{Testlet} objects and
return an Itempool object.}
\usage{
\S4method{c}{Item}(x, ...)

\S4method{c}{Itempool}(x, ...)

\S4method{c}{Testlet}(x, ...)
}
\arguments{
\item{x}{A list consist of \code{\link{Item-class}} objects.}

\item{...}{Additional arguments}
}
\value{
An \code{\link{Itempool-class}} object.
}
\description{
If the elements do not have id fields, function will assign default names.
}
\examples{
item1 <- item(a = 1.12, b = -2.1, c = 0.28)
item2 <- item(a = 2, b = 3.2, c = 0.21)

# Concatenate items
c(item1, item2)

ip <- itempool(a = c(1, 1.2), b = c(1, 2), c = c(.2, .4))
# Concatenate items and an Itempool object
c(item1, ip)
c(item1, item2, ip)
c(ip, item1, item2)
}
\author{
Emre Gonulates
}
