% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configurations_display.R
\name{configurations_display}
\alias{configurations_display}
\title{The configurations by iteration and instance}
\usage{
configurations_display(
  irace_results,
  rpd = TRUE,
  filename = NULL,
  interactive = base::interactive()
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{rpd}{(\code{logical(1)}) TRUE to plot performance as the relative
percentage deviation to best results per instance, FALSE to plot raw
performance.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}

\item{interactive}{(\code{logical(1)}) TRUE if the report may use interactive features (using \code{\link[plotly:ggplotly]{plotly::ggplotly()}}, \code{\link[plotly:plot_ly]{plotly::plot_ly()}} and \code{\link[DT:dataTableOutput]{DT::renderDataTable()}}) or FALSE if such features must be disabled. Defaults to the value returned by \code{interactive()},}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
This is a simplified version of the visualization you can obtain with \href{https://github.com/souzamarcelo/acviz}{\code{acviz}}. This function is currently VERY SLOW.
}
\examples{
\donttest{
iraceResults <- read_logfile(system.file(package="iraceplot", "exdata",
                                         "guide-example.Rdata", mustWork = TRUE))
configurations_display(iraceResults)
}
}
