% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ablation.R
\name{ablation}
\alias{ablation}
\title{Performs ablation between two configurations.}
\usage{
ablation(iraceLogFile = NULL, iraceResults = NULL, src = NULL,
  target = NULL, ab.params = NULL, n.instances = NULL, type = "full",
  seed = 1234567, ablationLogFile = "log-ablation.Rdata", pdf.file = NULL,
  pdf.width = 20, mar = c(12, 5, 4, 1), debugLevel = NULL)
}
\arguments{
\item{iraceLogFile}{Log file created by \pkg{irace}, this file must contain
the \code{iraceResults} object.}

\item{iraceResults}{Object created by \pkg{irace} and saved in
\code{scenario$logFile}.}

\item{src, target}{Source and target configuration IDs. If \code{NULL}, then
the first configuration ever evaluated is used as source and the best
configuration found is used as target.}

\item{ab.params}{Parameter names to be used for the ablation. They must be
in parameters$names.}

\item{n.instances}{Number of instances to be used for the "full" ablation,
if not provided firstTest instances are used.}

\item{type}{Type of ablation to perform, "full" will execute all instances
in the configurations to determine the best performing, "racing" will
apply racing to find the best configurations.}

\item{seed}{Numerical value to use as seed for the random number generation.}

\item{ablationLogFile}{Log file to save the ablation log.}

\item{pdf.file}{Prefix that will be used to save the plot file of the
ablation results.}

\item{pdf.width}{Width provided to create the pdf file.}

\item{mar}{Vector with the margins for the ablation plot.}

\item{debugLevel}{Integer value. Larger values produce more verbose
output. By default, the debugLevel given by the \code{iraceLogFile} /
\code{iraceResults}.}
}
\value{
A list containing the following elements:
 \describe{
   \item{configurations}{Configurations tested in the ablation.}
   \item{instances}{A matrix with the instances used in the experiments. First column has the 
    instances IDs from \code{iraceResults$scenario$instances}, second column the seed assigned to the instance.}
   \item{experiments}{A matrix with the results of the experiments (columns are configurations, rows are instances).}
   \item{scenario}{Scenario object with the settings used for the experiments.}
   \item{trajectory}{IDs of the best configurations at each step of the ablation.}
   \item{best}{Best configuration found in the experiments.}
 }
}
\description{
Ablation is a method for analyzing the differences between two configurations.
}
\examples{
\donttest{
irace.logfile <- file.path(system.file(package="irace"), "exdata", "sann.rda")
load(irace.logfile)
# Execute ablation between the first and the best configuration found by irace.
ablation(iraceResults = iraceResults, ablationLogFile = NULL)
# Execute ablation between two selected configurations, and selecting only a
# subset of parameters, directly reading the setup from the irace log file.
ablation(iraceLogFile = irace.logfile, src = 1, target = 10,
         ab.params = c("temp"), ablationLogFile = NULL)
}

}
\references{
C. Fawcett and H. H. Hoos. Analysing differences between algorithm
configurations through ablation. Journal of Heuristics, 22(4):431–458, 2016.
}
\author{
Leslie Pérez Cáceres and Manuel López-Ibáñez
}
