% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.R
\name{lbl_clean}
\alias{lbl_clean}
\title{Clean unused labels}
\usage{
lbl_clean(x)
}
\arguments{
\item{x}{A \code{\link[haven:labelled]{labelled}} vector}
}
\value{
A \code{\link[haven:labelled]{labelled}} vector
}
\description{
Remove labels that do not appear in the data. When converting labelled
values to a factor, this avoids the creation of additional factor levels.
}
\examples{
x <- haven::labelled(
  c(1, 2, 3, 1, 2, 3, 1, 2, 3),
  c(Q1 = 1, Q2 = 2, Q3 = 3, Q4 = 4)
)

lbl_clean(x)

# Compare the factor levels of the normal and cleaned labels after coercion
as_factor(lbl_clean(x))

as_factor(x)
}
\seealso{
Other lbl_helpers: 
\code{\link{lbl}()},
\code{\link{lbl_add}()},
\code{\link{lbl_define}()},
\code{\link{lbl_na_if}()},
\code{\link{lbl_relabel}()},
\code{\link{zap_ipums_attributes}()}
}
\concept{lbl_helpers}
