% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_read.R
\name{read_ipums_sf}
\alias{read_ipums_sf}
\title{Read spatial data from an IPUMS extract}
\usage{
read_ipums_sf(
  shape_file,
  file_select = NULL,
  vars = NULL,
  encoding = NULL,
  bind_multiple = FALSE,
  add_layer_var = NULL,
  verbose = FALSE,
  shape_layer = deprecated()
)
}
\arguments{
\item{shape_file}{Path to a single .shp file, or a .zip archive or
directory containing at least one .shp file. See Details section.}

\item{file_select}{If \code{shape_file} is a .zip archive or directory that
contains multiple files, an expression identifying the files to load.
Accepts a character string specifying the
file name, a \link[=selection_language]{tidyselect selection}, or index
position. If multiple files are selected, \code{bind_multiple} must be
equal to \code{TRUE}.}

\item{vars}{Names of variables to include in the output. Accepts a
character vector of names or a \link[=selection_language]{tidyselect selection}.
If \code{NULL}, includes all variables in the file.}

\item{encoding}{Encoding to use when reading the shape file. If \code{NULL},
defaults to \code{"latin1"} unless the file includes a .cpg metadata file
with encoding information. The default value should generally be
appropriate.}

\item{bind_multiple}{If \code{TRUE} and \code{shape_file} contains multiple .shp files,
row-bind the files into a single \code{sf} object. Useful when \code{shape_file}
contains multiple files that represent the same geographic units for
different extents (e.g. block-level data for multiple states).}

\item{add_layer_var}{If \code{TRUE}, add a variable to the output data indicating
the file that each row originates from. Defaults to \code{FALSE} unless
\code{bind_multiple = TRUE} and multiple files exist in \code{shape_file}.

The column name will always be prefixed with \code{"layer"}, but will be
adjusted to avoid name conflicts if another column named \code{"layer"} already
exists in the data.}

\item{verbose}{If \code{TRUE} report additional progress information on load.}

\item{shape_layer}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{file_select} instead.}
}
\value{
An \link[sf:sf]{sf} object
}
\description{
Read a spatial data file (also referred to as a GIS file or shapefile) from
an IPUMS extract into an \code{sf} object from the
\href{https://r-spatial.github.io/sf/}{sf} package.
}
\details{
Some IPUMS products provide shapefiles in a "nested" .zip archive. That is,
each shapefile (including a .shp as well as accompanying files) is
compressed in its own archive, and the collection of all
shapefiles provided in an extract is also compressed into a single .zip
archive.

\code{read_ipums_sf()} is designed to handle this structure. However, if any files
are altered such that an internal .zip archive contains \emph{multiple}
shapefiles, this function will throw an error. If this is the case, you may
need to manually unzip the downloaded file before loading it into R.
}
\examples{
\dontshow{if (requireNamespace("sf")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example shapefile from NHGIS
shape_ex1 <- ipums_example("nhgis0972_shape_small.zip")
data_ex1 <- read_nhgis(ipums_example("nhgis0972_csv.zip"), verbose = FALSE)

sf_data <- read_ipums_sf(shape_ex1)

sf_data

# To combine spatial data with tabular data without losing the attributes
# included in the tabular data, use an ipums shape join:
ipums_shape_full_join(data_ex1, sf_data, by = "GISJOIN")

shape_ex2 <- ipums_example("nhgis0712_shape_small.zip")

# Shapefiles are provided in .zip archives that may contain multiple
# files. Select a single file with `file_select`:
read_ipums_sf(shape_ex2, file_select = matches("us_pmsa_1990"))

# Or row-bind files with `bind_multiple`. This may be useful for files of
# the same geographic level that cover different extents)
read_ipums_sf(
  shape_ex2,
  file_select = matches("us_pmsa"),
  bind_multiple = TRUE
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=read_ipums_micro]{read_ipums_micro()}} or \code{\link[=read_nhgis]{read_nhgis()}} to read tabular data from
an IPUMS extract.

\code{\link[=ipums_list_files]{ipums_list_files()}} to list files in an IPUMS extract.
}
