% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_url.r
\name{ipums_website}
\alias{ipums_website}
\title{Launch a browser window to the ipums website}
\usage{
ipums_website(
  x,
  var,
  project = NULL,
  launch = TRUE,
  verbose = TRUE,
  var_label = NULL,
  homepage_if_missing = TRUE
)
}
\arguments{
\item{x}{A DDI or empty (if specifying project)}

\item{var}{A single variable name in a character vector}

\item{project}{If not using a DDI (or object with a project attribute)
A name of an IPUMS project, one of:
  "IPUMS-USA", "IPUMS-CPS", "IPUMS-International", "IPUMS-DHS",
  "ATUS-X", "AHTUS-X", "MTUS-X", "NHIS", "Higher Ed", "NHGIS",
  or "IPUMS Terra"}

\item{launch}{If \code{TRUE}, launch the website.}

\item{verbose}{If \code{TRUE}, message user if no variable specific websites are available}

\item{var_label}{Sometimes the variable label is useful for finding the correct URL. Only needed
if not passing in the ddi object.}

\item{homepage_if_missing}{If \code{TRUE}, Return homepage if project does not provide variable
specific web pages.}
}
\value{
The url to the page on ipums.org (silently if launch is \code{TRUE})
}
\description{
Takes a DDI (or you can specify a project directly) and
a variable name, and makes a best guess at the URL for
the variable's page on the IPUMS website. Note that
NHGIS and TerraPop do not have accessible pages for
variables.
}
\details{
Because some variables are constructed during the extract
creation process, the URL may not always work unfortunately.
}
\examples{
ddi <- read_ipums_ddi(ipums_example("cps_00006.xml"))
ipums_website(ddi, "MONTH", launch = FALSE)

\dontrun{
# Launches website
ipums_website(ddi, "MONTH")
}

# Can also specify project instead of using DDI
ipums_website(var = "RECTYPE", project = "IPUMS-CPS", launch = FALSE)


}
