% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\name{gen_multilevel}
\alias{gen_multilevel}
\title{Generate simulated data for multilevel models}
\usage{
gen_multilevel(n = 25, m = 6, sigma_e = 2, sigma_u0 = 2, sigma_u1 = 2,
  sigma_u01 = -2, beta0 = 0, beta1 = 2, x.jitter = 0.5, seed = NULL)
}
\arguments{
\item{n}{Sample size. Input either a single number for a balanced data set,
or a vector of length \code{m} indicating the sample size in each group.}

\item{m}{Number of groups/levels.}

\item{sigma_e}{The standard deviation of the errors.}

\item{sigma_u0}{The standard deviation of the random intercept.}

\item{sigma_u1}{The standard deviation of the random slopes.}

\item{sigma_u01}{The covariance of between the random intercept and the
random slope.}

\item{beta0}{The mean of the random intercept.}

\item{beta1}{The mean of the random slope.}

\item{x.jitter}{A small amount of jitter is added to the \code{X} variables
generated from a normal distribution with mean zero and standard deviation
equal to \code{x.jitter}.}

\item{seed}{(Optional) Random seed.}
}
\value{
A dataframe containing the response variable \code{y}, the
  unidimensional explanatory variables \code{X}, and the levels/groups
  (factors).
}
\description{
Generate simulated data for multilevel models
}
\examples{
gen_multilevel()

}
