% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_quantile.R
\name{ppi_quantile}
\alias{ppi_quantile}
\title{PPI Quantile Estimation}
\usage{
ppi_quantile(Y_l, f_l, f_u, q, alpha = 0.05, exact_grid = FALSE)
}
\arguments{
\item{Y_l}{(vector): n-vector of labeled outcomes.}

\item{f_l}{(vector): n-vector of predictions in the labeled data.}

\item{f_u}{(vector): N-vector of predictions in the unlabeled data.}

\item{q}{(float): Quantile to estimate. Must be in the range (0, 1).}

\item{alpha}{(scalar): type I error rate for hypothesis testing - values in
(0, 1); defaults to 0.05.}

\item{exact_grid}{(bool, optional): Whether to compute the exact solution
(TRUE) or an approximate solution based on a linearly spaced grid of 5000
values (FALSE).}
}
\value{
tuple: Lower and upper bounds of the prediction-powered confidence
interval for the quantile.
}
\description{
Helper function for PPI quantile estimation
}
\details{
Prediction Powered Inference (Angelopoulos et al., 2023)
\url{https://www.science.org/doi/10.1126/science.adi6000}
}
\examples{

dat <- simdat(model = "quantile")

form <- Y - f ~ X1

Y_l <- dat[dat$set == "labeled", all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set == "labeled", all.vars(form)[2]] |> matrix(ncol = 1)

f_u <- dat[dat$set == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

ppi_quantile(Y_l, f_l, f_u, q = 0.5)

}
