% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_table_get.R
\name{use_table_get}
\alias{use_table_get}
\title{Create a use (input flow) matrix}
\usage{
use_table_get(labelled_io_table = NULL, source = "germany_1990",
  geo = "DE", year = 1990, unit = "MIO_EUR", stk_flow = "DOM",
  households = FALSE, keep_total = FALSE, labelling = "iotables")
}
\arguments{
\item{labelled_io_table}{If you have created the IO table earlier with 
\code{\link{iotable_get}}, it is faster to work with the data
in the memory. Defaults to \code{NULL} when  the data will be retrieved from
the hard disk or from the Eurostat website invoking \code{\link{iotables_download}} 
and \code{\link{iotable_get}}.}

\item{source}{A data source, for example "naio_10_cp1700". Possible codes are "naio_10_cp1700",
"naio_10_cp1750", "naio_10_pyp1700", "naio_10_pyp1750", "naio_cp17_r2", "naio_17_agg_60_r2", 
"naio_17_agg_10_r2", "croatia_2010_1700", "croatia_2010_1800", 
"croatia_2010_1900". For further information consult the 
\href{http://ec.europa.eu/eurostat/web/esa-supply-use-input-tables/methodology/symmetric-input-output-tables}{Eurostat Symmetric Input-Output Tables} page.}

\item{geo}{A country code, for example, \code{SK}.}

\item{year}{A numeric variable containing the year. Defaults to \code{2010}, because this year has the most data.}

\item{unit}{A character string containing the currency unit, defaults to 
\code{MIO_NAC} (million national currency unit). The alternative is \code{MIO_EUR}.}

\item{stk_flow}{Defaults to \code{DOM}, alternative \code{IMP}.}

\item{households}{If you need to make household demand endogenous, or "close the households off", TRUE selects 
wages and final household consumption. This is needed for induced-effects calculations.}

\item{keep_total}{Logical variable. Defaults to \code{FALSE} and removes 
the totalling row and column from the matrix.}

\item{labelling}{Defaults to \code{iotables} which gives standard row and column names regardless of the
source of the table, or if it is a product x product, industry x industry or product x industry table.
The alternative is \code{short} which is the original short row or column code of Eurostat or OECD.}
}
\description{
Select the use table from a symmetric input-output table.
}
\examples{
use_de <- use_table_get( source = "germany_1990", geo = 'DE', year = 1990,
                       unit = "MIO_EUR", labelling  = 'iotables')
\dontrun{
use_table <-  iotables_download ( "naio_10_cp1700" ) \%>\%
 iotable_get (labelled_io_data = ., geo = "PL", 
              source = "naio_10_cp1700",
              year = 2010, unit = "MIO_EUR", 
              labelling = "short") \%>\%
 use_table_get ( labelled_io_table = .)
 }
}
