% Generated by roxygen2 (4.0.1): do not edit by hand
\name{qdraw}
\alias{qdraw}
\title{Draw to a plot device}
\usage{
qdraw(expr, file = NULL, device = getOption("plot.device"), width = NULL,
  height = NULL, aspect.ratio = NULL, units = NULL, res = NULL, ...)
}
\arguments{
\item{expr}{expression for plotting}

\item{file}{filename}

\item{device}{plot device}

\item{width}{plot width [default: 5]}

\item{height}{plot height [default: 5]}

\item{aspect.ratio}{ratio of width to height}

\item{units}{unit of plot dimension [default: "in"]}

\item{res}{bitmap resolution, used only by bitmap formats [default: 300]}

\item{...}{other arguments passed to the plot device function}
}
\description{
This funtion draws a plot to screen, a file, or both.
}
\details{
To send the plot to screen, set \code{device} to NA (default).
Optionally, to print the plot on screen to a file, specify \code{file}.

If \code{device} is \code{NULL}, the plot will be sent to the
the specified \code{file} using a printing device inferred from the file
extension.

Set the global option \code{plot.device} to affect multiple plots.
Graphical parameters including \code{width}, \code{height}, \code{res},
\code{units} are obtained from the global option \code{getOption("plot")}.
}
\examples{
\dontrun{
# Set device to jpeg (remember to update file extensions for printed plots)
options(plot.device=jpeg)
qdraw(plot(1:10), "plot.jpeg")

# Enable automatic plot format inference (default)
To send the plot directly to a file, set global option \\code{plot.device}
to a printing device.
options(plot.device=NULL)

# Plot directly to file (format is inferred)
qdraw(plot(1:10), "plot.pdf")

# Plot to screen, then print to file (display will not be closed)
qdraw(plot(1:10), "plot.png", device=NA)

# If an error occurs, be sure to clear the current plot
dev.off()
# or clear all plots
graphics.off()
}
}

