% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_minmax_pois.R
\name{sim_minmax_pois}
\alias{sim_minmax_pois}
\title{sim_minmax_pois}
\usage{
sim_minmax_pois(
  demand,
  lambda,
  leadtime,
  service_level,
  Max,
  shortage_cost = FALSE,
  inventory_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{lambda}{rate of demand in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{Max}{Max quantity for order up to level}

\item{shortage_cost}{shortage cost per unit of sales lost}

\item{inventory_cost}{inventory cost per unit.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a Min,max policy or aslo called s,S policy,  .
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. the min is calculated based on a poisson distribution.
}
\examples{
sim_minmax_pois(demand = rpois(50,8),lambda = 4,leadtime = 4,shortage_cost = 20,
Max = 32,service_level = 0.70,inventory_cost = 50)

}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
