% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettySummary.R
\name{prettySummary}
\alias{prettySummary}
\title{Provide a pretty summary of model results}
\usage{
prettySummary(x)
}
\arguments{
\item{x}{output object from \code{\link{modelCosts}}}
}
\description{
This function is useful for presenting the main results (coefficients, tests,
etc.) of models in a paper
}
\examples{
data(invacost)

### Cleaning steps
# Eliminating data with no information on starting and ending years
invacost <- invacost[-which(is.na(invacost$Probable_starting_year_adjusted)), ]
invacost <- invacost[-which(is.na(invacost$Probable_ending_year_adjusted)), ]
# Keeping only observed and reliable costs
invacost <- invacost[invacost$Implementation == "Observed", ]
invacost <- invacost[which(invacost$Method_reliability == "High"), ]
# Eliminating data with no usable cost value
invacost <- invacost[-which(is.na(invacost$Cost_estimate_per_year_2017_USD_exchange_rate)), ]

### Expansion
\donttest{
db.over.time <- expandYearlyCosts(invacost,
                                  startcolumn = "Probable_starting_year_adjusted",
                                  endcolumn = "Probable_ending_year_adjusted")
                                  
### Analysis                                   
res <- modelCosts(db.over.time)
prettySummary(res)}
}
\references{
\url{https://github.com/Farewe/invacost}

Leroy Boris, Kramer Andrew M, Vaissière Anne-Charlotte, Courchamp Franck & Diagne Christophe (2020). Analysing global economic costs of invasive alien species with the
invacost R package. biorXiv. \doi{10.1101/2020.12.10.419432}
}
\author{
Boris Leroy \email{leroy.boris@gmail.com}, Andrew Kramer, Anne-Charlotte
Vaissière, Christophe Diagne
}
