% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yupana_export.R
\name{yupana_export}
\alias{yupana_export}
\title{Graph options to export}
\usage{
yupana_export(
  data,
  type = NA,
  xlab = NA,
  ylab = NA,
  glab = NA,
  ylimits = NA,
  xrotation = c(0, 0.5, 0.5),
  xtext = NA,
  gtext = NA,
  legend = "top",
  sig = NA,
  error = NA,
  color = TRUE,
  opt = NA,
  dimension = c(20, 10, 100)
)
}
\arguments{
\item{data}{Result from yupana_analysis or yupana_import.}

\item{type}{Plot type}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{limits of the y axis}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in group}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{sig}{Column with the significance}

\item{error}{Show the error bar ("ste" or "std").}

\item{color}{colored figure (TRUE), otherwise black & white (FALSE)}

\item{opt}{Add news layer to the plot}

\item{dimension}{Dimension of graphs}
}
\value{
data frame
}
\description{
Function to export the graph options and model parameters
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=172957346")
# browseURL(url)

fb <- gsheet2tbl(url)

smr <- yupana_analysis(data = fb
                       , last_factor = "bloque"
                       , response = "spad_83"
                       , model_factors = "block + geno*riego"
                       , comparison = c("geno", "riego")
                       )
                       
gtab <- yupana_export(smr, type = "line", ylimits = c(0, 100, 2))

#> import

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=1202800640")
# browseURL(url)

fb <- gsheet2tbl(url)

info <- yupana_import(fb)

etab <- yupana_export(info)

info2 <- yupana_import(etab)

etab2 <- yupana_export(info2)

}

}
