% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_smr.R
\name{plot_smr}
\alias{plot_smr}
\title{Plot summary data}
\usage{
plot_smr(
  data,
  type = NULL,
  x = NULL,
  y = NULL,
  group = NULL,
  xlab = NULL,
  ylab = NULL,
  glab = NULL,
  ylimits = NULL,
  xrotation = c(0, 0.5, 0.5),
  xtext = NULL,
  gtext = NULL,
  legend = "top",
  sig = NULL,
  error = NULL,
  color = TRUE,
  opt = NULL
)
}
\arguments{
\item{data}{Output from ger_testcomp function}

\item{type}{Type of graphic. "bar" or "line"}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{group}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{limits of the y axis}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in group}

\item{legend}{the position of legends ("none", "left", "right", "bottom",
"top", or two-element numeric vector)}

\item{sig}{Column with the significance}

\item{error}{Show the error bar ("ste" or "std").}

\item{color}{colored figure (TRUE), otherwise black & white (FALSE)}

\item{opt}{Add news layer to the plot}
}
\value{
plot
}
\description{
Graph summary data into bar o line plot
}
\details{
If the table is a out put of \code{mean_comparison(graph_opts = TRUE)}
function. Its contain all the parameter for the plot.
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/"
              , "edit#gid=172957346")
# browseURL(url)

fb <- gsheet2tbl(url)


yrs <- yupana_analysis(data = fb
                       , response = "hi"
                       , model_factors = "geno*treat"
                       , comparison = c("geno", "treat")
                       )

yrs$meancomp \%>\% plot_smr(type = "bar"
                          , x = "geno"
                          , y = "hi"
                          , group = "treat"
                          , ylimits = c(0, 1, 0.1)
                          , opt = "theme_minimal()"
                          , color = c("brown", "blue", "black")
                          , sig = "sig"
                          ) +
                           facet_grid(.~ treat)

}

}
