% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso_interactions.R
\name{post_ds_interaction}
\alias{post_ds_interaction}
\title{Post-double selection estimator for interactions}
\usage{
post_ds_interaction(
  data,
  treat,
  moderator,
  outcome,
  control_vars,
  panel_vars = NULL,
  moderator_marg = TRUE,
  cluster = NULL,
  method = "double selection"
)
}
\arguments{
\item{data}{data.frame to find the relevant variables.}

\item{treat}{string with the name of the treatment variable.}

\item{moderator}{string with the name of the moderating variable.}

\item{outcome}{string with the name of the outcome variable.}

\item{control_vars}{vector of strings with the names of the
control variables to include.}

\item{panel_vars}{vector of strings with the names of categorical
variables to include as fixed effects.}

\item{moderator_marg}{logical indicating if the lower-order term
of the moderator should be included ()}

\item{cluster}{string with the name of the cluster variable.}

\item{method}{string indicating which method to use. The default
is \code{"double selection"} selects variables based on the
outcome and treatment/interaction variables and \code{"single
selection"} only selects on the outcome.}
}
\value{
Returns an object of the class \code{lm} with an
  additional \code{clustervcv} object containing the
  cluster-robust variance matrix estimate when \code{cluster} is
  provided.
}
\description{
\code{post_ds_interaction} applies post-double selection to the
estimation of an interaction in a linear model.
}
\details{
The \code{post_ds_interaction} implements the post-double
  selection estimator of Belloni et al (2014) as applied to
  interactions, which was proposed by Blackwell and Olson (2019).
  Variables passed to \code{panel_vars} are considered factors
  for fixed effects and whose "base effects" are removed by
  demeaning all variables by those factors. Interactions between
  the moderator and all variables (including the factors generated
  by \code{panel_vars}) are generated and passed to the
  post-double selection procedure. Base terms for the treatment,
  moderator, and control variables are forced to be included in
  the final post-double selection OLS. The \code{cluster} argument
  adjusts the lasso
}
\examples{
data(remit)

controls <- c("l1gdp", "l1pop", "l1nbr5", "l12gr", "l1migr",
"elec3")

post_ds_out <- post_ds_interaction(
  data = remit, treat = "remit",
  moderator = "dict", outcome = "Protest",
  control_vars = controls,
  cluster = "caseid"
)

}
\references{
Alexandre Belloni, Victor Chernozhukov, Christian
  Hansen, Inference on Treatment Effects after Selection among
  High-Dimensional Controls, The Review of Economic Studies,
  Volume 81, Issue 2, April 2014, Pages 608-650,
  \doi{10.1093/restud/rdt044}

Matthew Blackwell and Michael Olson.. "Reducing Model Misspectation
  and Bias in the Estimation of Interactions." Political Analysis,
2021.
}
