% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotChart.R
\name{PlotChart}
\alias{PlotChart}
\title{plots the interference chart}
\usage{
PlotChart(IC, type = "Sorensen", Thickness = 30, x.lims = NULL,
  radials = FALSE)
}
\arguments{
\item{IC}{Dataframe from \code{\link{InterferenceTable}}.}

\item{type}{Chart type (see Details).}

\item{Thickness}{If not NULL, a horizontal line is drawn at h= Thickness
(in micrometers).}

\item{x.lims}{Plotting range, horizontal axis (when NULL,
defaults to \code{c(0,0.05)} for Raith-Sorensen plots
 and to \code{c(0,2500)} for Michel-Levy plots).}

\item{radials}{If TRUE iso-birefringence lines will be plotted
(on Michel-Levy chart only).}
}
\value{
a Sorensen or Michel-Levy plot
}
\description{
\code{PlotChart} plots the result of a call
to \code{\link{InterferenceTable}}
}
\details{
If \code{type} belongs to c("Sorensen","S","Raith-Sorensen","RS"), the
function plots interference colors on a grid with birefringence
as horizontal axis and thickness as vertical axis. If \code{type} belongs to
c("Michel-Levy","ML","MichelLevy","M"), the horizontal axis is retardation
(in nanometers) as in the classical Michel-Levy plot. When \code{radials} is
set to TRUE, birefringence appears as oblique lines with rounded values
printed at their end
}
\examples{
\dontrun{
PlotChart(IC=IC1,type="RS")
PlotChart(IC=IC1,type="ML")
PlotChart(IC=IC1,type="ML",radials=TRUE)
PlotChart(IC=IC1,type="ML",x.lims=range(IC1[,6]),Thickness = 35)
}

}
\references{
Sorensen, B.E. (2013) A revised Michel-Levy interference colour chart based
on first-principles calculations. Eur. J. Mineral., 2013, 25, 5-10.
DOI:10.1127/0935-1221/2013/0025-2252
}
\author{
Olivier Eterradossi, \email{olivier.eterradossi@mines-ales.fr}
}
