% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histbin.R
\name{histbin}
\alias{histbin}
\title{Create a histogram with outlier bins}
\usage{
histbin(
  data,
  x,
  left = NULL,
  right = NULL,
  line = FALSE,
  bins = 30,
  fill = "#E7B800",
  fill_outliers = "#a7d1a7"
)
}
\arguments{
\item{data}{data.frame}

\item{x}{variable name in data.frame `data` that should be mapped}

\item{left}{numeric indicating the floor of the range}

\item{right}{numeric indicating the ceiling of the range}

\item{line}{show density line (default is FALSE)}

\item{bins}{numeric to indicate number of bins}

\item{fill}{color used to fill bars}

\item{fill_outliers}{color used to fill outlier bars}
}
\value{
a ggplot2 object
}
\description{
Visualize the distribution of a single continuous variable by dividing the x axis into bins and counting the number of observations in each bin.
Data points that are considered outliers can be binned together. This might be helpful to display numerical data over a very wide range of values in a compact way.
}
\details{
Wrapper function around `ggplot2::geom_histogram()`. The method is based on suggestions from \url{https://edwinth.github.io/blog/outlier-bin/}.
}
\examples{
histbin(MTPL2, premium)
histbin(MTPL2, premium, left = 30, right = 120, line = TRUE, bins = 30)

}
