% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_3riskpremium.R
\name{univariate_risk_premium}
\alias{univariate_risk_premium}
\title{Univariate risk premium}
\usage{
univariate_risk_premium(
  df,
  x,
  severity,
  exposure,
  nclaims = NULL,
  premium = NULL
)
}
\arguments{
\item{df}{data.frame with insurance portfolio}

\item{x}{column in \code{df} with risk factor}

\item{severity}{column in \code{df} with severity (default is NULL)}

\item{exposure}{column in \code{df} with exposure}

\item{nclaims}{column in \code{df} with number of claims}

\item{premium}{column in \code{df} with premium (default is NULL)}
}
\value{
An list of class \code{univ_freq} with components
\item{df}{data frame with risk premium}
\item{xvar}{name of column in df with risk factor}
\item{severity}{name of column in df with severity}
\item{nclaims}{name of column in df with number of claims}
\item{exposure}{name of column in df with exposure}
\item{premium}{name of column in df with premium}
}
\description{
Risk premium for discrete risk factors in an insurance portfolio. For each level of the risk factor the risk premium is equal to the ratio between the severity and the exposure.
}
\examples{
univariate_risk_premium(MTPL2, x = area, severity = amount, exposure = exposure)
}
\author{
Martin Haringa
}
