% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_3riskpremium_plot.R
\name{autoplot.univ_premium}
\alias{autoplot.univ_premium}
\title{Automatically create a ggplot for objects obtained from univariate_risk_premium()}
\usage{
\method{autoplot}{univ_premium}(
  x,
  background = TRUE,
  labels = TRUE,
  sort = FALSE,
  dec.mark = ",",
  color = "dodgerblue",
  color_bg = "#E7B800"
)
}
\arguments{
\item{x}{univ_premium object produced by \code{univariate_risk_premium()}}

\item{background}{show exposure as a histogram (default is TRUE)}

\item{labels}{show labels with the exposure (default is TRUE)}

\item{sort}{sort (or order) risk factor into descending order by exposure (default is FALSE)}

\item{dec.mark}{control the format of the decimal point, as well as the mark between intervals before the decimal point, choose either "," (default) or "."}

\item{color}{change the color of the points and line ("dodgerblue" is default)}

\item{color_bg}{change the color of the histogram ("#E7B800" is default)}
}
\value{
a ggplot2 object
}
\description{
Takes an object produced by \code{univariate_risk_premium()}, and plots the average risk premium.
}
\examples{
library(ggplot2)
x <- univariate_risk_premium(MTPL2, x = area, severity = amount, exposure = exposure)
autoplot(x)

}
