% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_package_compile.R
\name{stan_package_compile}
\alias{stan_package_compile}
\title{Compile the Stan models in an R package.}
\usage{
stan_package_compile(
  models = instantiate::stan_package_model_files(),
  cmdstan_install = Sys.getenv("CMDSTAN_INSTALL"),
  verbose = TRUE,
  quiet = FALSE,
  pedantic = FALSE,
  include_paths = NULL,
  user_header = NULL,
  cpp_options = list(),
  stanc_options = list(),
  force_recompile = getOption("cmdstanr_force_recompile", default = FALSE),
  compile_model_methods = FALSE,
  compile_hessian_method = FALSE,
  compile_standalone = FALSE,
  threads = FALSE
)
}
\arguments{
\item{models}{Character vector of file paths to Stan model source code
files. Defaults to the Stan files in \verb{./inst/stan/}
because all the Stan model files must live in the \verb{inst/stan/} folder
for an R package built with \code{instantiate}.}

\item{cmdstan_install}{Character of length 1, how CmdStan was installed. The
installation method determines how \code{instantiate} looks up CmdStan.
Set the default value with the \code{CMDSTAN_INSTALL} environment variable.
Choices:
\enumerate{
\item \code{"internal"}: Use the copy of CmdStan installed internally inside the
\code{instantiate} package file system. Before using this option,
CmdStan must be installed in the package file system. To do this,
set the \code{CMDSTAN_INSTALL} environment variable to \code{"internal"} before
installing \code{instantiate}.
\item \code{"fixed"}: Use the copy of CmdStan that was located at the value
contained in \code{Sys.getenv("CMDSTAN")} at the time \code{instantiate}
was installed. In this case, the path to CmdStan is not inside
\code{instantiate} itself, but it is fixed at installation time
and does not depend on the current value of
\code{Sys.getenv("CMDSTAN")} at runtime.
\item \code{"cmdstanr"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. The \code{cmdstanr} package must be installed. If it
is not installed, the function returns the empty string \code{""}.
\item \code{""} (default): Try all 3 options in the order above to find a valid
installed copy of CmdStan.
}}

\item{verbose}{Logical of length 1, whether to set the
\code{cmdstanr_verbose} global option to print more compiler messages
than usual.}

\item{quiet}{Argument to \code{cmdstanr::cmdstan_model()} to control compilation.}

\item{pedantic}{Logical of length 1, whether to activate pedantic
mode when compiling the Stan models. See the \code{cmdstanr} documentation
for details.}

\item{include_paths}{Argument to \code{cmdstanr::cmdstan_model()}
to control model compilation.}

\item{user_header}{Argument to \code{cmdstanr::cmdstan_model()}
to control model compilation.}

\item{cpp_options}{Argument to \code{cmdstanr::cmdstan_model()}
to control model compilation.}

\item{stanc_options}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{force_recompile}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{compile_model_methods}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{compile_hessian_method}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{compile_standalone}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}

\item{threads}{Argument to \code{cmdstanr::cmdstan_model()}
to model control compilation.}
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
Compile all Stan models in a directory, usually in a package.
}
\details{
If building a package using \code{instantiate}, all Stan model files
must live in a folder called \verb{inst/stan/} in the package source
directory.
}
\examples{
if (identical(Sys.getenv("INSTANTIATE_EXAMPLES"), "true")) {
path <- tempfile()
stan_package_create(path = path)
stan_package_configure(path = path)
models <- stan_package_model_files(path)
list.files(file.path(path, "inst", "stan"))
stan_package_compile(models)
list.files(file.path(path, "inst", "stan"))
}
}
\seealso{
Other packages: 
\code{\link{stan_cmdstan_path}()},
\code{\link{stan_package_clean}()},
\code{\link{stan_package_configure}()},
\code{\link{stan_package_model_files}()}
}
\concept{packages}
