% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kill_pid.R
\name{kill_pid}
\alias{kill_pid}
\title{kill (i.e.: stop) running processes by there pid}
\usage{
kill_pid(pid, s = 0, m = 0, h = 0, ...)
}
\arguments{
\item{pid}{an integer vector with process id numbers (i.e.: can kill severa pid at once!)}

\item{s}{numeric. number of seconds to wait before killing the processes}

\item{m}{numeric. number of minutes to wait before killing the processes}

\item{h}{numeric. number of hours to wait before killing the processes}

\item{...}{not used.}
}
\value{
output from system
}
\description{
kill (i.e.: stop) running processes by there pid.
It spawns a new Rscript which runs \link[tools]{pskill} on the pid-s
}
\examples{
\dontrun{
# create several running processes of Rscript (to shitdown)
system("Rscript -e repeat{2+2}", wait = FALSE) # this process should be stuck   
system("Rscript -e repeat{2+2}", wait = FALSE) # this process should be stuck   
# here are there pid numbers:
get_Rscript_PID() 
# let's kill them:
kill_pid(get_Rscript_PID())
# they are gone...
get_Rscript_PID() # we no longer have Rscripts running
}
}
\references{
tasklist details from microsoft homepage: \url{http://technet.microsoft.com/en-us/library/bb491010.aspx}
pskill details from microsoft homepage: \url{http://technet.microsoft.com/en-us/sysinternals/bb896683.aspx}
}
\seealso{
\code{\link{get_tasklist}}, \code{\link{get_Rscript_PID}}, \code{\link{get_pid}},
\code{\link{kill_pid}}, \code{\link{kill_all_Rscript_s}}, \link[tools]{pskill}
}
