% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_par_.R
\name{inspect_par_dirichlet}
\alias{inspect_par_dirichlet}
\title{Validate parameters for the Dirichlet distribution}
\usage{
inspect_par_dirichlet(x)
}
\arguments{
\item{x}{An arbitrary object.}
}
\value{
\code{inspect_par_dirichlet} does not return any output. There are two possible outcomes:
\itemize{
\item The call is silent if \code{x} is an eligible vector of parameters for the Dirichlet distribution.
\item An informative error message is thrown otherwise.
}
}
\description{
\code{inspect_par_dirichlet} checks if an object is an eligible vector of parameters for the Dirichlet distribution. This can be useful to validate inputs, intermediate calculations or outputs in user-defined functions.
}
\details{
\code{inspect_par_dirichlet} conducts a series of tests to check if \code{x} is an eligible vector of parameters for the Dirichlet distribution. Namely, \code{inspect_par_dirichlet} checks if:
\itemize{
\item \code{x} is \code{NULL} or empty.
\item \code{x} is an atomic vector
\item \code{x} is numeric
\item \code{x} has \code{NA} or \code{NaN} values.
\item All elements of \code{x} are positive.
}
}
\examples{
# Calls that pass silently:
x1 <- c(1, 1, 1)
x2 <- c(2, 5)
inspect_par_dirichlet(x1)
inspect_par_dirichlet(x2)

# Calls that throw an informative error message:
mylist <- list(NULL, factor(1, 1, 1),
 matrix(c(1, 1, 1)), c("1", "1", "1"), list(1, 1, 1), c(1, NA),
  c(1, NaN, 1), c(TRUE, FALSE), numeric(0), c(-1, 1, 1))
try(inspect_par_dirichlet(mylist[[1]]))
try(inspect_par_dirichlet(mylist[[2]]))
try(inspect_par_dirichlet(mylist[[3]]))
try(inspect_par_dirichlet(mylist[[4]]))
try(inspect_par_dirichlet(mylist[[5]]))
try(inspect_par_dirichlet(mylist[[6]]))
try(inspect_par_dirichlet(mylist[[7]]))
try(inspect_par_dirichlet(mylist[[8]]))
try(inspect_par_dirichlet(mylist[[9]]))
try(inspect_par_dirichlet(mylist[[10]]))

}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_par_bernoulli}} to validate parameters for the Bernoulli/Binomial distribution.
\item \code{\link[inspector]{inspect_par_multinomial}} to validate parameters for the Multinomial distribution.
\item \code{\link[inspector]{inspect_par_beta}} to validate parameters for the Beta distribution.
\item \code{\link[inspector]{inspect_par_haldane}} to validate parameters for the Haldane distribution.
}
}
