% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_intercept.R
\name{has_intercept}
\alias{has_intercept}
\title{Checks if model has an intercept}
\usage{
has_intercept(x, verbose = TRUE)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Toggle warnings.}
}
\value{
\code{TRUE} if \code{x} has an intercept, \code{FALSE} otherwise.
}
\description{
Checks if model has an intercept.
}
\examples{
model <- lm(mpg ~ 0 + gear, data = mtcars)
has_intercept(model)

model <- lm(mpg ~ gear, data = mtcars)
has_intercept(model)

\dontshow{if (require("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lmer(Reaction ~ 0 + Days + (Days | Subject), data = sleepstudy)
has_intercept(model)

model <- lmer(Reaction ~ Days + (Days | Subject), data = sleepstudy)
has_intercept(model)
\dontshow{\}) # examplesIf}
}
